import React from 'react';

/**
 * @since 4.6.0
 */
export default function PaymentMethodIcon({ paymentMethod }: { paymentMethod: string }) {
    if (!paymentMethod) {
        return null;
    }

    switch (paymentMethod) {
        case 'stripe':
        case 'stripe_checkout':
        case 'stripe_payment_element':
        case 'stripe_ach':
        case 'stripe_sepa':
        case 'stripe_ideal':
        case 'stripe_becs':
            return <StripeIcon />;
        case 'stripe_apple_pay':
            return <ApplePayIcon />;
        case 'stripe_google_pay':
            return <GooglePayIcon />;
        case 'paypal':
        case 'paypal_standard':
        case 'paypal_donations':
            return <PaypalIcon />;
        case 'mollie':
            return <MollieIcon />;
        case 'gocardless':
            return <GoCardlessIcon />;
        case 'razorpay':
            return <RazorPayIcon />;
        case 'braintree':
            return <BraintreeIcon />;
        case 'payfast':
            return <PayfastIcon />;
        case 'payu':
            return <PayUIcon />;
        default:
            return null;
    }
}

/**
 * @since 4.6.0
 */
function StripeIcon() {
    return (
        <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M11.2285 8.23401C9.87346 7.73068 9.13513 7.34484 9.13513 6.73151C9.13513 6.21318 9.56096 5.91734 10.321 5.91734C11.7101 5.91734 13.1368 6.45234 14.1193 6.93401L14.6743 3.50818C13.8951 3.13651 12.3018 2.52734 10.0993 2.52734C8.54096 2.52734 7.24513 2.93484 6.3193 3.69484C5.3568 4.48984 4.85513 5.63984 4.85513 7.02818C4.85513 9.54734 6.3943 10.6215 8.8943 11.5307C10.5076 12.104 11.0435 12.5123 11.0435 13.1423C11.0435 13.7523 10.5193 14.1048 9.57513 14.1048C8.40596 14.1048 6.47846 13.5307 5.21596 12.7898L4.6543 16.254C5.74096 16.864 7.7418 17.494 9.81846 17.494C11.4651 17.494 12.8385 17.1048 13.7643 16.364C14.8018 15.5498 15.3393 14.3457 15.3393 12.7898C15.3393 10.214 13.7651 9.13984 11.2268 8.23318H11.2285V8.23401Z" fill="#6772E5" />
        </svg>
    );
}

/**
 * @since 4.6.0
 */
function ApplePayIcon() {
    return (
        <svg width="49" height="20" viewBox="0 0 49 20" fill="none" xmlns="http://www.w3.org/2000/svg">
            <g clipPath="url(#clip0_4983_17030)">
                <path d="M8.86741 2.569C8.29869 3.24199 7.38855 3.77299 6.4785 3.69706C6.36476 2.78711 6.81026 1.82009 7.33168 1.22284C7.9004 0.5309 8.89585 0.0379147 9.70163 0C9.79642 0.947962 9.42665 1.87697 8.86741 2.569ZM9.69225 3.87725C8.37452 3.80142 7.24646 4.62607 6.62078 4.62607C5.98571 4.62607 5.02817 3.91517 3.98542 3.93412C2.62988 3.95308 1.36902 4.72085 0.676986 5.94379C-0.745005 8.38957 0.307317 12.0109 1.68182 14.0016C2.3549 14.9875 3.16068 16.0682 4.22239 16.0302C5.22732 15.9923 5.62542 15.3762 6.83888 15.3762C8.06173 15.3762 8.41253 16.0302 9.47424 16.0113C10.5739 15.9923 11.2659 15.0255 11.939 14.0395C12.7067 12.9209 13.0196 11.8307 13.0386 11.7738C13.0196 11.7549 10.9152 10.9492 10.8962 8.52227C10.8773 6.49365 12.5552 5.52673 12.631 5.46986C11.683 4.06682 10.2042 3.91517 9.69225 3.87725ZM17.3046 1.12806V15.9071H19.5986V10.8544H22.7743C25.6751 10.8544 27.7133 8.8637 27.7133 5.9818C27.7133 3.1 25.713 1.12815 22.8502 1.12815L17.3046 1.12806ZM19.5986 3.06199H22.2434C24.2342 3.06199 25.3718 4.1237 25.3718 5.99118C25.3718 7.85867 24.2342 8.92995 22.234 8.92995H19.5986V3.06199ZM31.9032 16.0208C33.3442 16.0208 34.6808 15.2909 35.2875 14.1343H35.3349V15.907H37.4584V8.55071C37.4584 6.41782 35.7521 5.04322 33.1261 5.04322C30.6898 5.04322 28.8886 6.43678 28.8223 8.35166H30.8889C31.0595 7.44161 31.9031 6.84436 33.0597 6.84436C34.4628 6.84436 35.2496 7.49848 35.2496 8.70246V9.51763L32.3867 9.68825C29.7229 9.84938 28.282 10.9396 28.282 12.8356C28.282 14.7505 29.7703 16.0208 31.9032 16.0208ZM32.5194 14.267C31.2966 14.267 30.5192 13.6793 30.5192 12.7787C30.5192 11.8498 31.2681 11.3094 32.6995 11.2241L35.2496 11.0629V11.8971C35.2496 13.2811 34.0741 14.267 32.5195 14.267M40.2929 19.9264C42.5302 19.9264 43.5824 19.0734 44.5019 16.4853L48.5307 5.1854H46.1987L43.497 13.9162H43.4496L40.7479 5.1854H38.3495L42.2361 15.9449L42.0276 16.5991C41.6769 17.7082 41.1081 18.1348 40.0938 18.1348C39.9137 18.1348 39.563 18.1158 39.4207 18.0969V19.8696C39.5534 19.9075 40.1221 19.9264 40.2928 19.9264" fill="black" />
            </g>
            <defs>
                <clipPath id="clip0_4983_17030">
                    <rect width="48.5308" height="20" fill="white" />
                </clipPath>
            </defs>
        </svg>
    );
}

/**
 * @since 4.6.0
 */
function GooglePayIcon() {
    return (
        <svg width="51" height="20" viewBox="0 0 51 20" fill="none" xmlns="http://www.w3.org/2000/svg">
            <g clipPath="url(#clip0_4983_17014)">
                <path d="M35.5807 5.3982C36.9606 5.3982 38.027 5.77458 38.8425 6.52732C39.6579 7.27997 40.0341 8.2836 40.0341 9.53811V15.5597H38.2779V14.1799H38.2151C37.4625 15.309 36.3961 15.8735 35.1416 15.8735C34.0752 15.8735 33.1343 15.5598 32.3817 14.9326C31.6917 14.3054 31.2526 13.4272 31.2526 12.4863C31.2526 11.4827 31.6289 10.6672 32.3817 10.04C33.1343 9.41271 34.2007 9.16183 35.4552 9.16183C36.5842 9.16183 37.4625 9.35007 38.1524 9.78909V9.35007C38.1524 8.76458 37.9338 8.17918 37.4967 7.79771L37.3996 7.71919C36.8979 7.28007 36.2706 7.02919 35.5807 7.02919C34.5144 7.02919 33.6989 7.46827 33.1343 8.34644L31.5036 7.34262C32.5071 6.02536 33.8243 5.3982 35.5807 5.3982ZM26.7364 1.13281C27.8619 1.13281 28.9315 1.52448 29.7867 2.25487L29.9354 2.38722C30.8136 3.13997 31.2526 4.26909 31.2526 5.46085C31.2526 6.65262 30.8136 7.71899 29.9354 8.53438C29.0573 9.34977 27.9909 9.78889 26.7364 9.78889L23.7256 9.72615V15.5597H21.8438V1.13281H26.7364ZM35.8315 10.6671C35.0788 10.6671 34.4516 10.8553 33.9498 11.2316C33.448 11.5452 33.1971 11.9843 33.1971 12.5488C33.1971 13.0507 33.4481 13.4897 33.8243 13.7407C34.2635 14.0543 34.7652 14.2424 35.2671 14.2424C35.9695 14.2424 36.6721 13.9692 37.2216 13.4738L37.337 13.3643C37.9642 12.7998 38.2779 12.1098 38.2779 11.357C37.7134 10.918 36.8979 10.667 35.8316 10.667M26.862 2.88899H23.7257V7.90732H26.862C27.5519 7.90732 28.2419 7.65644 28.681 7.15468C29.6845 6.21379 29.6845 4.64566 28.7438 3.70468L28.681 3.64193C28.1791 3.14017 27.5519 2.82654 26.8619 2.88928M50.1957 5.71183L43.9859 19.9506H42.1041L44.4249 14.9953L40.3478 5.77458H42.355L45.3031 12.8625H45.3658L48.2512 5.77458H50.1957V5.71183Z" fill="#5F6368" />
                <path d="M16.2609 8.47087C16.2609 7.90636 16.1982 7.34185 16.1354 6.77734H8.29492V9.97636H12.7484C12.5602 10.9799 11.9957 11.9208 11.1176 12.4854V14.5553H13.8147C15.3829 13.1126 16.261 10.9799 16.261 8.47097" fill="#4285F4" />
                <path d="M8.29415 16.5632C10.5522 16.5632 12.434 15.8105 13.814 14.556L11.1168 12.4861C10.364 12.9878 9.42317 13.3015 8.29415 13.3015C6.1614 13.3015 4.27964 11.8588 3.65238 9.85156H0.892578V11.9842C2.33523 14.8069 5.15787 16.5632 8.29415 16.5632Z" fill="#34A853" />
                <path d="M3.6537 9.8512C3.27743 8.84757 3.27743 7.71855 3.6537 6.65218V4.51953H0.893897C-0.297966 6.84041 -0.297966 9.60032 0.893897 11.9838L3.6537 9.8512Z" fill="#FBBC04" />
                <path d="M8.29595 3.26513C9.48772 3.26513 10.6167 3.70425 11.495 4.51964L13.8785 2.13611C12.373 0.756112 10.3659 -0.0592803 8.3586 0.00336671C5.22233 0.00336671 2.33703 1.75974 0.957031 4.58239L3.71693 6.71503C4.28144 4.70778 6.16321 3.26513 8.29595 3.26513Z" fill="#EA4335" />
            </g>
            <defs>
                <clipPath id="clip0_4983_17014">
                    <rect width="50.1961" height="20" fill="white" />
                </clipPath>
            </defs>
        </svg>
    );
}

/**
 * @since 4.6.0
 */
function PaypalIcon() {
    return (
        <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M11.2285 8.23401C9.87346 7.73068 9.13513 7.34484 9.13513 6.73151C9.13513 6.21318 9.56096 5.91734 10.321 5.91734C11.7101 5.91734 13.1368 6.45234 14.1193 6.93401L14.6743 3.50818C13.8951 3.13651 12.3018 2.52734 10.0993 2.52734C8.54096 2.52734 7.24513 2.93484 6.3193 3.69484C5.3568 4.48984 4.85513 5.63984 4.85513 7.02818C4.85513 9.54734 6.3943 10.6215 8.8943 11.5307C10.5076 12.104 11.0435 12.5123 11.0435 13.1423C11.0435 13.7523 10.5193 14.1048 9.57513 14.1048C8.40596 14.1048 6.47846 13.5307 5.21596 12.7898L4.6543 16.254C5.74096 16.864 7.7418 17.494 9.81846 17.494C11.4651 17.494 12.8385 17.1048 13.7643 16.364C14.8018 15.5498 15.3393 14.3457 15.3393 12.7898C15.3393 10.214 13.7651 9.13984 11.2268 8.23318H11.2285V8.23401Z" fill="#6772E5" />
        </svg>
    );
}

/**
 * @since 4.6.0
 */
function MollieIcon() {
    return (
        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M22 19.0625H18C17.59 19.0625 17.25 18.7225 17.25 18.3125V12.3125C17.25 11.981 17.1183 11.663 16.8839 11.4286C16.6495 11.1942 16.3315 11.0625 16 11.0625C15.6685 11.0625 15.3505 11.1942 15.1161 11.4286C14.8817 11.663 14.75 11.981 14.75 12.3125V18.3125C14.75 18.7225 14.41 19.0625 14 19.0625H10C9.59 19.0625 9.25 18.7225 9.25 18.3125V12.3125C9.25 11.981 9.1183 11.663 8.88388 11.4286C8.64946 11.1942 8.33152 11.0625 8 11.0625C7.66848 11.0625 7.35054 11.1942 7.11612 11.4286C6.8817 11.663 6.75 11.981 6.75 12.3125V18.3125C6.75 18.7225 6.41 19.0625 6 19.0625H2C1.59 19.0625 1.25 18.7225 1.25 18.3125V12.3125C1.25 8.5925 4.28 5.5625 8 5.5625C9.45 5.5625 10.84 6.0225 12 6.8725C13.1593 6.02003 14.561 5.56097 16 5.5625C19.72 5.5625 22.75 8.5925 22.75 12.3125V18.3125C22.75 18.7225 22.41 19.0625 22 19.0625ZM18.75 17.5625H21.25V12.3125C21.25 9.4225 18.89 7.0625 16 7.0625C14.71 7.0625 13.46 7.5425 12.5 8.4025C12.22 8.6625 11.78 8.6625 11.5 8.4025C10.5374 7.54127 9.29162 7.0643 8 7.0625C5.11 7.0625 2.75 9.4225 2.75 12.3125V17.5625H5.25V12.3125C5.25 10.7925 6.48 9.5625 8 9.5625C9.52 9.5625 10.75 10.7925 10.75 12.3125V17.5625H13.25V12.3125C13.25 10.7925 14.48 9.5625 16 9.5625C17.52 9.5625 18.75 10.7925 18.75 12.3125V17.5625Z" fill="black" />
        </svg>
    );
}

/**
 * @since 4.6.0
 */
function BraintreeIcon() {
    return (
        <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path d="M5.51753 13.6547H8.66219C11.0895 13.6547 12.3035 12.8547 12.3035 11.31C12.3035 9.79333 11.0069 8.96533 8.46886 8.96533H5.51753V13.6547ZM5.51753 2.34467V6.70333H8.27619C10.3449 6.70333 11.4209 5.93067 11.4209 4.524C11.4209 3.08933 10.3175 2.34467 8.24819 2.34467H5.51753ZM1.13086 16V13.6547H2.98019V2.34467H1.13153V0H8.52419C11.9175 0 13.9862 1.572 13.9862 4.30333C13.9862 6.09667 12.9382 7.2 11.6142 7.724C13.5175 8.24867 14.8689 9.6 14.8689 11.448C14.8689 14.372 12.6069 16 8.91019 16H1.13153" fill="black" />
        </svg>
    );
}

/**
 * @since 4.6.0
 */
function PayfastIcon() {
    return (
        <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path fillRule="evenodd" clipRule="evenodd" d="M8.43375 2.35372C2.48166 3.80719 0.371648 11.2075 4.67312 15.5434C9.54847 20.4579 17.6594 16.9712 17.68 9.95216C17.6847 8.33376 17.6601 8.2976 16.531 8.26504C13.7372 8.18488 10.0846 8.28224 10.0846 8.43696C10.0846 8.53032 11.2521 9.85168 12.6789 11.3733C14.1057 12.8948 15.2732 14.2225 15.2732 14.3238C15.2732 15.3837 12.1394 15.6928 10.3405 14.8102C6.4704 12.9114 3.71669 6.76317 5.82953 4.7388C6.9578 3.65781 8.76831 4.08753 12.8056 6.3943C14.2849 7.23959 15.5522 7.89588 15.6217 7.85296C15.6914 7.80988 15.125 6.55956 14.3634 5.07417L12.9785 2.37385L12.357 2.26347C11.3956 2.09288 9.30543 2.14083 8.43375 2.35372Z" fill="#1E1A14" />
        </svg>
    );
}

/**
 * @since 4.6.0
 */
function GoCardlessIcon() {
    return (
        <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
            <path fillRule="evenodd" clipRule="evenodd" d="M8.43375 2.35372C2.48166 3.80719 0.371648 11.2075 4.67312 15.5434C9.54847 20.4579 17.6594 16.9712 17.68 9.95216C17.6847 8.33376 17.6601 8.2976 16.531 8.26504C13.7372 8.18488 10.0846 8.28224 10.0846 8.43696C10.0846 8.53032 11.2521 9.85168 12.6789 11.3733C14.1057 12.8948 15.2732 14.2225 15.2732 14.3238C15.2732 15.3837 12.1394 15.6928 10.3405 14.8102C6.4704 12.9114 3.71669 6.76317 5.82953 4.7388C6.9578 3.65781 8.76831 4.08753 12.8056 6.3943C14.2849 7.23959 15.5522 7.89588 15.6217 7.85296C15.6914 7.80988 15.125 6.55956 14.3634 5.07417L12.9785 2.37385L12.357 2.26347C11.3956 2.09288 9.30543 2.14083 8.43375 2.35372Z" fill="#1E1A14" />
        </svg>
    );
}

/**
 * @since 4.6.0
 */
function RazorPayIcon() {
    return null;
}

/**
 * @since 4.6.0
 */
function PayUIcon() {
    return null;
}
